function updateDivisionOptions() {
    const company = document.getElementById('company').value;
    const divisionSelect = document.getElementById('division');
    divisionSelect.innerHTML = ''; // Bersihkan opsi divisi sebelumnya

    let divisions = [];

    if (company === 'Fresh On Time Seafood') {
        // Tampilkan Borongan untuk Fresh On Time Seafood
        divisions = ['Driver', 'Security', 'Marketing Lokal', 'Borongan', 'Lainnya'];
    } else {
        // Sembunyikan Borongan untuk perusahaan lain
        divisions = ['Driver', 'Security', 'Marketing Lokal', 'Lainnya'];
    }

    // Tambahkan opsi divisi yang baru
    divisions.forEach(division => {
        const option = document.createElement('option');
        option.value = division;
        option.textContent = division;
        divisionSelect.appendChild(option);
    });
}

// Inisialisasi opsi divisi saat halaman dimuat
document.addEventListener('DOMContentLoaded', updateDivisionOptions);

function calculateLoan() {
    const amount = parseFloat(document.getElementById('amount').value);
    const tenor = parseInt(document.getElementById('tenor').value);
    const company = document.getElementById('company').value;
    const division = document.getElementById('division').value;

    let interestRate = 0; // Default 2% per bulan
    let serviceFee = 0; // Biaya layanan tetap
    let admin = 0; // Biaya admin

    if (division === 'Security' || division === 'Marketing Lokal' || division === 'Driver') {
        interestRate = 45; // 45% per tahun untuk divisi Security, Marketing, Driver
        serviceFee = amount * 0.0030; // Biaya layanan 0.30%
    } else if (division === 'Borongan' && company === 'Fresh On Time Seafood') {
        interestRate = 3 * 12; // 3% per bulan untuk divisi Borongan
        serviceFee = amount * 0.0015; // Biaya layanan 0.15%
    } else if (company === 'International Leather Works') {
        interestRate = 35; // 35% per tahun untuk International Leather Works
        serviceFee = amount * 0.0030; // Biaya layanan 0.30%
    } else {
        interestRate = 40; // 40% per tahun untuk perusahaan lainnya
        serviceFee = amount * 0.0030; // Biaya layanan 0.30%
    }

    // Biaya admin sesuai nominal pinjaman
    if (division === 'Borongan' && company === 'Fresh On Time Seafood' && amount === 500000) {
        admin = 5000; // Rp 5.000 untuk 500.000
    } else if (amount <= 1000000) {
        admin = 10000; // 500rb - 1jt = 10.000
    } else if (amount > 1000000 && amount <= 3000000) {
        admin = 20000; // 1.1jt - 3jt = 20.000
    } else if (amount > 3000000 && amount <= 5000000) {
        admin = 40000; // 3.1jt - 5jt = 40.000
    } else if (amount > 5000000 && amount <= 10000000) {
        admin = 80000; // 5.1jt - 10jt = 80.000
    } else if (amount > 10000000) {
        admin = 100000; // > 10jt = 100.000
    }

    const bunga = (amount * ((interestRate / 100) / 12)) * tenor;
    const cicilanPerBulan = (amount + bunga) / tenor + serviceFee;

    function roundInstallment(value) {
        const remainder = value % 1000;
        if (remainder === 0) {
            return value;
        } else if (remainder > 500) {
            return value + (1000 - remainder); // Bulatkan ke atas
        } else {
            return value - remainder + 500; // Bulatkan ke bawah ke 500 terdekat
        }
    }

    let cicilanPerBulanBulat = roundInstallment(cicilanPerBulan);

    // Display hasil hitungan
    document.getElementById('displayAmount').textContent = 'Rp. ' + amount.toLocaleString();
    document.getElementById('displayTenor').textContent = tenor.toLocaleString() + (division === 'Borongan' ? ' Periode' : ' Bulan');
    document.getElementById('displayAdmin').textContent = 'Rp. ' + admin.toLocaleString();
    document.getElementById('displayCicilan').textContent = 'Rp. ' + cicilanPerBulanBulat.toLocaleString();

    // Ubah label Cicilan Perbulan menjadi Cicilan Perperiode jika divisi Borongan
    if (division === 'Borongan') {
        document.querySelector('label[for="displayCicilan"]').textContent = 'Cicilan Perperiode';
        document.getElementById('labelPeriode').textContent = 'Periode';
    } else {
        document.querySelector('label[for="displayCicilan"]').textContent = 'Cicilan Perbulan';
        document.getElementById('labelPeriode').textContent = 'Bulan';
    }

    const installmentTable = document.getElementById('installmentTable');
    installmentTable.innerHTML = ''; // Bersihkan hasil sebelumnya

    const installments = [];

    for (let month = 1; month <= tenor; month++) {
        let principalInstallment = amount / tenor;
        let interest = bunga / tenor;
        let totalInstallment;

        if (month === 1) {
            totalInstallment = principalInstallment + interest + serviceFee + admin;
        } else {
            totalInstallment = principalInstallment + interest + serviceFee;
        }
        
        totalInstallment = roundInstallment(totalInstallment);
        principalInstallment = roundInstallment(principalInstallment);

        const row = document.createElement('tr');
        row.innerHTML = `
            <td class="text-center">${month}</td>
            <td>${'Rp. ' + principalInstallment.toLocaleString()}</td>
            <td>${'Rp. ' + totalInstallment.toLocaleString()}</td>
        `;
        installmentTable.appendChild(row);

        installments.push({
            periode: month,
            cicilanPokok: principalInstallment,
            totalCicilan: totalInstallment
        });
    }

    localStorage.setItem('installments', JSON.stringify(installments));
    document.getElementById('result').style.display = 'block';
    document.getElementById('result').scrollIntoView({ behavior: 'smooth' });
}
