<?php
// Koneksi ke database
include 'koneksi.php';

// Mengecek apakah ada parameter ID Pinjam yang dikirimkan
if (isset($_GET['loan_id'])) {
    $loan_id = $_GET['loan_id'];

    // Query untuk mengambil data cicilan berdasarkan loan_id
    $sql = "SELECT id_pinjam, nama_konsumen, pokok_pinjaman, jumlah_tenor_seharusnya, cicilan_per_bulan, sisa_tenor, sisa_pinjaman FROM tbl_cicilan WHERE id_pinjam = ?";
    $stmt = $conn->prepare($sql);
    $stmt->bind_param("s", $loan_id);
    $stmt->execute();
    $result = $stmt->get_result();

    if ($result->num_rows > 0) {
        // Mengambil data hasil query
        $row = $result->fetch_assoc();
        echo json_encode([
            'status' => 'success',
            'id_pinjam' => $row['id_pinjam'],
            'nama_konsumen' => $row['nama_konsumen'],
            'pokok_pinjaman' => $row['pokok_pinjaman'],
            'jumlah_tenor_seharusnya' => $row['jumlah_tenor_seharusnya'],
            'cicilan_per_bulan' => $row['cicilan_per_bulan'],
            'sisa_tenor' => $row['sisa_tenor'],
            'sisa_pinjaman' => $row['sisa_pinjaman']
        ]);
    } else {
        echo json_encode([
            'status' => 'error',
            'message' => 'ID Pinjam tidak ditemukan'
        ]);
    }
} else {
    echo json_encode([
        'status' => 'error',
        'message' => 'Parameter ID Pinjam tidak disertakan'
    ]);
}

// Menutup koneksi
$conn->close();
?>
